/**************************/
/*                        */
/*   AntiISDA Warrior     */
/* Colecovision version   */
/*   Copyright 2004 by    */
/*  Ventzislav Tzvetkov   */
/* http://drhirudo.hit.bg */
/*                        */
/* Compile with Hi-Tech C */
/**************************/

/* Version 1.0

*/

#include <coleco.h>

#include <string.h>

#define chrgen  0x0000
#define coltab  0x2000
#define chrtab  0x1800
#define sprtab  0x3800
#define sprgen  0x1b00

#define UP    1
#define RIGHT 2
#define DOWN  4
#define LEFT  8

#define AGENT 128

#define BOMB 91

#define RIGHT 2
#define LEFT  8

char Version[]="$VER: AntiISDA Warrior CV V1.0 (c) 2004",
     ShootsText[]="Shoots: n",Level,
     Direction,Counter=0,Ammo,x,y,*Bomb="[",LevelLine[41];

/* From graphics.c */
extern byte PATTERNRLE[];
extern byte COLOR[];

/* From sounds.c */
extern byte ding_sound[];
extern byte noise_sound[];

char LevelScreen(char LevelNumber);
void GameOver();
void Win();

static void ding (void)
{
 start_sound (ding_sound,7);
}

static void noise (void)
{
 start_sound (noise_sound,7);
}

/* Non Maskable Interrupt */
void nmi(void)
{
 /* Play sounds */
 update_sound();
 /* Update sprites in VRAM with sprites[] */
/* update_sprites (32,sprgen); */
}

/* Init vdp game's screen */
static void init_vdp (void)
{
 /* temporary variable to be use in FOR functions */
 register byte i;

 /* temporary variables for the upload COLOR functions */
 int colpos;

 byte col;

 /* turn display off */
 screen_off ();
 /* disable NMI */
 disable_nmi ();
 /* clear VRAM */
 fill_vram (0,0,0x4000);

 /* Upload my tiles patterns */

 rle2vram (PATTERNRLE,chrgen);

 /* Upload tiles Color */

 colpos=coltab;

 for (i=0;i<32;++i)
 {
  col=COLOR[i];
  fill_vram (colpos,col,64);
  colpos +=64;
 }

 /* Fill Pattern and Color in VRAM */

 for (i=0;i<8;++i)
 {
  get_vram (chrgen+i*256,sprites,256);
  put_vram (chrgen+8*256+i*256,sprites,256);
  put_vram (chrgen+8*512+i*256,sprites,256);
  get_vram (coltab+i*256,sprites,256);
  put_vram (coltab+8*256+i*256,sprites,256);
  put_vram (coltab+8*512+i*256,sprites,256);
 }

 /* Clear sprites from screen */
 clear_sprites (0,64);
 /* Black screen border */
 vdp_out (7,0xf1);
 /* turn display on */
 screen_on ();
 /* enable NMI */
 enable_nmi ();
}

/* Clear Screen */
void clrscr(void)
{
 fill_vram (chrtab,0x20,0x300);
}

/* PRINT AT X,Y ON SCREEN */
void print_at (byte x, byte y,char *s)
{
 register unsigned i;
 disable_nmi ();
 i = strlen (s);
 put_vram (chrtab+y*32+x,s,i);
 enable_nmi ();
}

/* Main routine */
void main(void)
{

byte Direction,rnd,key;

for (;;) {

 init_vdp();
 clrscr();
 print_at(8,1," Ɋ");

 print_at(1,4,"Your server full with all thosetwenty years old  ļ  Warez of which nobody cares any-more since  ages,  unfortunatelyis being attacked  by some  agents and they  want  to formatyour  only  hard disk  you  everowned (40MB).");

 print_at(1,14,"They attack from various ports,so you have to aim your pingbombmuch  more  precisely  with  thejoystick. Press (FIRE) to shoot.");

 print_at(1,22,"(c) by Ventzislav Tzvetkov 2004");
 print_at(5,23,"http://drhirudo.hit.bg");

for (;;){if ((joypad_1)&0xf0) break;rnd++;}
clrscr();srand(rnd);

Ammo=LevelScreen(Level=1);

y=23;x=(rand()%16)+9;
print_at(x,y,Bomb);

for (;;)
{key=0;
for (;;){if ((joypad_1)&0xf0) break;}
noise();delay(4);
for (;;){
  if ((joypad_1)&LEFT)  Direction=LEFT;
  if ((joypad_1)&RIGHT) Direction=RIGHT;

 print_at(x,y--," ");
 if (Direction==LEFT) x-=(x>0); else if (Direction==RIGHT)x+=(x<31);
 if (y==Level && LevelLine[x]) {LevelLine[x]=0;
 switch (rand()%2) {
 case 1:print_at(x,y,"");break;
 case 2:print_at(x,y,"");break;
 default:print_at(x,y,"");break;
 }
  ding();delay(25);Counter++;
  print_at(x,y," ");y=0;
 }
if (Counter==10) {Ammo=LevelScreen(++Level);Counter=0;}
if (y==0) {Direction=0;y=23;x=(rand()%16)+8;Ammo--;
if (Ammo<10) {ShootsText[8]=Ammo+'0';
print_at(11,0,ShootsText);}
print_at(x,y,Bomb);
break;}
print_at(x,y,Bomb);
delay(1);
    }
if (Level==8) { Win(); break; }
if (Ammo==0) { GameOver(); break;}
  }
delay(5); }
}

char LevelScreen(char LevelNumber) {
char LevelText[2],Color=0;
int cx;
if (LevelNumber==8) return 100;
LevelText[0]='0'+LevelNumber;
LevelText[1]=0;clrscr();
print_at(12,10,"Level ");print_at(18,10,LevelText);
delay(10);
clrscr();

LevelText[0]=AGENT;
for (cx=1;cx<32;cx++) LevelLine[cx]=0;
do {
cx=rand()%32;
if (!LevelLine[cx]) {LevelLine[cx]=AGENT;
print_at(cx,LevelNumber,LevelText);LevelText[0]+=8;Color++;}

} while (Color<10);

return 30-LevelNumber*2;
}

void GameOver() {
clrscr();

print_at(7,1,"Bad Luck, Webmaster!");
print_at(3,3,"All your ammunitions are goneand you just can not hold it anymore. Your site  was removed andyour hard disk is now low  levelformated  and  broken  by  thesefellow chaps!");
print_at(9,15,"G A M E   O V E R");
print_at(4,17,"Press (FIRE) to play again");
for (;;){if ((joypad_1)&0xf0) break;}
}

void Win() {
clrscr();

print_at(3,1,"Congratulatulations, You won");
print_at(2,4,"All   agents are gone, andyou just found that one of thesejerks  holds  a  pirated copy of\"Stacker\", which doubles up yourdisks space as the  readme says.Now  you  can  upload even  moregreat big soft and hardwarez.   Thanks to .");

print_at(4,17,"Press (FIRE) to play again");

for (;;){if ((joypad_1)&0xf0) break;}
}
